<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// Ana Gösterim Fonksiyonu
function pro_slider_wp_display() {
    $options = get_option( 'pro_slider_settings', array() );
    $main_slider_args = _pro_slider_get_query_args($options);
    $slider_query = new WP_Query( $main_slider_args );

    if ( !$slider_query->have_posts() ) { return ''; }

    return _pro_slider_generate_swiper_html($slider_query, $options);
}

// WP_Query argümanlarını oluşturan yardımcı fonksiyon
function _pro_slider_get_query_args($options, $exclude_ids = array()) {
    $count = isset($options['slide_count']) ? intval($options['slide_count']) : 8;
    $order_value = isset($options['slide_order']) ? $options['slide_order'] : 'date_desc';
    $categories = isset($options['categories']) && is_array($options['categories']) ? $options['categories'] : array();
    $orderby = 'date'; $order = 'DESC';
    if ($order_value === 'date_asc') { $order = 'ASC'; }
    if ($order_value === 'rand') { $orderby = 'rand'; }
    $args = array( 'post_type' => 'post', 'posts_per_page' => $count, 'post_status' => 'publish', 'orderby' => $orderby, 'order' => $order, 'post__not_in' => $exclude_ids, 'meta_query' => array( array( 'key' => '_thumbnail_id' ) ) );
    if ( ! empty( $categories ) ) { $args['category__in'] = $categories; }
    return $args;
}

// Swiper HTML'ini oluşturan yardımcı fonksiyon (NİHAİ VERSİYON)
function _pro_slider_generate_swiper_html($slider_query, $options) {
    // Ayarları al
    $height = isset($options['slider_height']) ? intval($options['slider_height']) : 500;
    $main_color = isset($options['main_color']) ? esc_attr($options['main_color']) : '#E53935';
    $nav_color = isset($options['nav_color']) ? esc_attr($options['nav_color']) : '#FFFFFF';
    $show_thumbnails = isset($options['show_thumbnails']) && $options['show_thumbnails'] === 'on';
    $show_arrows = isset($options['show_arrows']) ? ($options['show_arrows'] === 'on') : true;
    $thumb_frame_color = isset($options['thumbnail_frame_color']) ? esc_attr($options['thumbnail_frame_color']) : '#FFFFFF';
    $thumb_count = isset($options['thumbnail_count']) ? intval($options['thumbnail_count']) : 6;
    $thumb_gap = 15; // Küçük resimler arası boşluk (piksel)

    ob_start();
    $instance_id = 'pro-slider-wp-instance-' . uniqid();
    ?>
    <style>
        .<?php echo $instance_id; ?> .slide-button { background-color: <?php echo $main_color; ?>; }
        .<?php echo $instance_id; ?> .pro-slider-nav { color: <?php echo $nav_color; ?>; }
        .<?php echo $instance_id; ?> .swiper-pagination-bullet-active { background-color: <?php echo $nav_color; ?> !important; }
        .<?php echo $instance_id; ?> .thumbnail-item.is-active { border-color: <?php echo $thumb_frame_color; ?> !important; }
        
        <?php if ($show_thumbnails): ?>
        /* YENİ: Dinamik Genişlik Hesaplaması */
        .<?php echo $instance_id; ?> .thumbnail-item {
            width: calc((100% - (<?php echo ($thumb_count - 1) * $thumb_gap; ?>px)) / <?php echo $thumb_count; ?>);
            max-width: 150px; /* Çok genişlemesini önle */
        }
        <?php endif; ?>
    </style>
    
    <div class="pro-slider-wp <?php echo $instance_id; ?>">
        <div class="pro-slider-main-wrapper">
            <div class="swiper pro-slider-main" style="height:<?php echo $height; ?>px;">
                <div class="swiper-wrapper">
                    <?php while ( $slider_query->have_posts() ) : $slider_query->the_post(); ?><div class="swiper-slide" style="background-image: url('<?php echo get_the_post_thumbnail_url( get_the_ID(), 'large' ); ?>');"><div class="slide-content"><h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2><div class="slide-excerpt"><?php the_excerpt(); ?></div><a href="<?php the_permalink(); ?>" class="slide-button">Devamını Oku</a></div></div><?php endwhile; ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
            <?php if ($show_arrows) : ?>
            <div class="pro-slider-nav pro-slider-prev-btn">&#10094;</div>
            <div class="pro-slider-nav pro-slider-next-btn">&#10095;</div>
            <?php endif; ?>
        </div>
        
        <?php if ($show_thumbnails) : ?>
        <div class="pro-slider-thumbs-scroller">
            <div class="pro-slider-thumbs-inner" style="gap: <?php echo $thumb_gap; ?>px;">
            <?php $slide_index = 0; ?>
            <?php $slider_query->rewind_posts(); ?>
            <?php while ( $slider_query->have_posts() ) : $slider_query->the_post(); ?>
                <div class="thumbnail-item" data-index="<?php echo $slide_index; ?>">
                    <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'thumbnail' ); ?>" />
                </div>
            <?php $slide_index++; endwhile; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php
    wp_reset_postdata();
    return ob_get_clean();
}